const express = require('express');
const path = require('path');
const { createProxyMiddleware } = require('http-proxy-middleware');
const dcs = require('../src/dcs');

const PORT = Number(process.env.PORT) || 80;
const STATIC_PATH = '../build';

const app = express();

app.use('/partner2_production_version.json', createProxyMiddleware('/partner2_production_version.json', {
    changeOrigin: true,
    secure: false,
    target: 'https://partner.yandex-team.ru',
}));

dcs.forEach(dc => {
    const route = `^/api/${dc}`;

    app.use(route, createProxyMiddleware('/api', {
        changeOrigin: true,
        pathRewrite: {
            [route]: '/api',
        },
        secure: false,
        target: `https://creator${dc}.partner.yandex-team.ru`,
    }));
});

app.use(express.static(path.resolve(__dirname, STATIC_PATH)));

app.get('*', (req, res) => {
    res.sendFile(path.resolve(__dirname, `${STATIC_PATH}/index.html`));
});

app.listen(PORT, () => {
    console.log(`Listening on: http://localhost:${PORT}`);
});
