import dcs from '../dcs';

import {fetchDbImages, fetchProductionTags} from './createBetaFormActions';
import {fetchJSON} from '../lib/http';

export const INIT_APP = 'INIT_APP';

export function initApp() {
    return (dispatch, getState) => {
        dcs.forEach(dc => {
            dispatch(_fetchDcData(dc));
        });
    };
}

export const FETCH_BETA_LIST = 'FETCH_BETA_LIST';

export function fetchBetaList(dc) {
    return dispatch => {
        dispatch(_requestBetaList(dc));

        fetchJSON(`/api/${dc}/3/betas`)
            .then(betaList => dispatch(_receiveBetaList(dc, betaList)))
            .catch(error => {
                dispatch(_receiveBetaListError(dc, error))
                console.error(error);
            });
    };
}

function _fetchDcData(dc) {
    return dispatch => {
        dispatch(_requestBetaList(dc));

        fetchJSON(`/api/${dc}/3/betas`)
            .then(betaList => dispatch(_receiveBetaList(dc, betaList)))
            .then(_fetchRest(dc, dispatch))
            .catch(error => {
                dispatch(_receiveBetaListError(dc, error))
                console.error(error);
            });
    };
}

function _fetchRest(dc, dispatch) {
    dispatch(fetchDbImages(dc));
    dispatch(fetchProductionTags());
}

export const REQUEST_BETA_LIST = 'REQUEST_BETA_LIST';

function _requestBetaList(dc) {
    return {
        type: REQUEST_BETA_LIST,
        dc
    };
}

export const RECEIVE_BETA_LIST = 'RECEIVE_BETA_LIST';

function _receiveBetaList(dc, betaList) {
    return {
        type: RECEIVE_BETA_LIST,
        dc,
        betaList
    };
}

export const RECEIVE_BETA_LIST_ERROR = 'RECEIVE_BETA_LIST_ERROR';

function _receiveBetaListError(dc, error) {
    return {
        type: RECEIVE_BETA_LIST_ERROR,
        dc,
        error
    };
}

export const UPDATE_BETA_IN_INDEX = 'UPDATE_BETA_IN_INDEX';

export function updateBetaInIndex(dc, beta) {
    return {
        type: UPDATE_BETA_IN_INDEX,
        dc,
        beta
    };
}
