import React, {Component} from 'react';

import {IndexRedirect, Router, Route, browserHistory} from 'react-router';

import CreateBetaPage from '../../containers/CreateBetaPage/CreateBetaPage';
import IndexPage from '../../containers/IndexPage/IndexPage';
import BetaDetailsPage from '../../containers/BetaDetailsPage/BetaDetailsPage';

import './App.css';

const IndexRoute = () => <IndexPage />;
const MyBetasRoute = () => <IndexPage myBetas={true}/>;

class App extends Component {
    render() {
        return (
            <Router history={browserHistory}>
                <Route path='/'>
                    <IndexRedirect to='/my' />
                    <Route path='/list' component={IndexRoute}/>
                    <Route path='/beta/:dc/:port' component={BetaDetailsPage}/>
                    <Route path='/my' component={MyBetasRoute}/>
                    <Route path='/create' component={CreateBetaPage}/>
                </Route>
            </Router>
        );
    }
}

export default App;
