import React, {Component} from 'react';

import Link from 'teatime-components/component/Link';

import './AppFooter.css';

class AppFooter extends Component {
    render() {
        return (
            <div className='AppFooter'>
                {this._renderVersion()}
                <Link className='AppFooter__link' href='https://creator2-vla.partner.yandex.ru/swagger/?url=https://creator2-vla.partner.yandex.ru/api/3/swagger.json/#!/beta/delete_betas_betaPort'>
                    Документация на API
                </Link>
                <Link className='AppFooter__link' href='https://github.yandex-team.ru/partner/creator-frontend'>
                    Исходный код фронтенда
                </Link>
                <Link className='AppFooter__link' href='https://github.yandex-team.ru/partner/creator'>
                    Исходный код бэкенда
                </Link>
                <Link className='AppFooter__link' href='https://wiki.yandex-team.ru/partner/w/partner-creator/'>
                    Вики
                </Link>
                <Link className='AppFooter__link' href='https://st.yandex-team.ru/filters/filter?query=Status%3A%20!%20Closed%20and%20Components%3A%20creator%20'>
                     Открытые задачи в Startrek
                </Link>
                <Link className='AppFooter__link' href='https://st.yandex-team.ru/createTicket?queue=INFRASTRUCTUREPI&type=task&components=creator&assignee=bessarabov'>
                    Создать задачу в Startrek
                </Link>
            </div>
        );
    }

    _renderVersion() {
        const version = process.env.VERSION;

        if (!version) {
            return null;
        }

        return (
            <div className="AppFooter__version">
                Версия {version}
            </div>
        );
    }
}

export default AppFooter;
