import React, {Component} from 'react';
import cookie from 'cookie';

import {Link as RouterLink} from 'react-router';
const {Link} = require('teatime-components');

import './AppHeader.css';

class AppHeader extends Component {
    render() {
        const username = cookie.parse(document.cookie).yandex_login;

        return (
            <div className='AppHeader'>
                <div className='AppHeader__left-pane'>
                    <RouterLink className='AppHeader__arrow' to='/my'>
                        <div className='AppHeader__arrow-label'>
                            Креатор
                        </div>
                    </RouterLink>
                    <div className='AppHeader__menu'>
                        <div className='AppHeader__menu-item'>
                            <RouterLink
                                activeClassName='AppHeader__menu-item-active-link'
                                className='AppHeader__menu-item-link'
                                to='/my'
                            >
                                Мои беты
                            </RouterLink>
                        </div>
                        <div className='AppHeader__menu-item'>
                            <RouterLink
                                activeClassName='AppHeader__menu-item-active-link'
                                className='AppHeader__menu-item-link'
                                to='/list'
                            >
                                Все беты
                            </RouterLink>
                        </div>
                    </div>
                </div>
                <div className='AppHeader__right-pane'>
                    <div>
                        <Link 
                            size={'m'}
                            className='AppHeader__menu-button'
                            theme='normal'
                            href='/create'
                        >
                            Создать бету
                        </Link>
                    </div>
                    <div className='AppHeader__user'></div>
                    <img className='AppHeader__avatar' alt='Avatar' src={`//center.yandex-team.ru/api/v1/user/${username}/avatar/100.jpg`}/>
                </div>
            </div>
        );
    }
}

export default AppHeader;
