import React from 'react';

import {Button} from 'teatime-components';
import copy from 'copy-text-to-clipboard';

import './BetaDBConfig.css';

function BetaDBConfig(props: {port: string | number; dc: string}) {
    const {port, dc} = props;
    const dbPort = Number(port) - 300;

    const config = `{
    "partnerdb2": {
        "host" : "creator${dc}.partner.yandex.ru",
        "port" : ${dbPort},
        "user" : "root",
        "password" : ""
    }
}`;

    return (
        <div>
            <textarea
                className='BetaDBConfig'
                cols={70}
                rows={8}
                value={config}
            />
            <Button
                className='BetaDBConfig__button'
                onClick={() => copy(config)}
            >
                Скопировать
            </Button>
        </div>
    );
}

export default BetaDBConfig;
