import React from 'react';

import {Button} from 'teatime-components';
import copy from 'copy-text-to-clipboard';

import './BetaDBConnectCommand.css';

function BetaDBConnectCommand(props: {port: string | number; dc: string}) {
    const {port, dc} = props;
    const dbPort = Number(port) - 300;

    const config = `mysql -u root \\
    --host=creator-${dc}.partner.yandex-team.ru \\
    --port=${dbPort} \\
    --password= \\
    --default-character-set=utf8 \\
    partner`;

    return (
        <div>
            <pre className='BetaDBConnectCommand'>{config}</pre>
            <Button
                className='BetaDBConnectCommand__button'
                onClick={() => copy(config)}
            >
                Скопировать
            </Button>
        </div>
    );
}

export default BetaDBConnectCommand;
