import React, {Component} from 'react';
import cookie from 'cookie';
import moment from 'moment';

import Spin from 'teatime-components/component/Spin';

import BetaListItem from '../BetaListItem/BetaListItem';
import {BetaType} from '../../types';

import './BetaList.css';

type BetaListProps = {
    header: unknown;
    compact?: boolean;
    betaList: BetaType[];
    myBetas: unknown;
    beta: BetaType;
    dc: string;
    pendingPort: unknown;
    listIsPending: boolean;
    selectedBetaPort: number;
    onDeleteClick: (port: number) => void;
};

class BetaList extends Component<BetaListProps> {
    render() {
        const {header} = this.props;

        return (
            <tbody className='BetaList'>
                <tr>
                    <td className='BetaList__cell' colSpan={100}>
                        <h3>{header}</h3>
                    </td>
                </tr>
                {this._renderHeader()}
                {this._renderBetas()}
            </tbody>
        );
    }

    _renderHeader() {
        const {compact} = this.props;

        return (
            <tr>
                <td className='BetaList__cell BetaList__header'></td>
                <td className='BetaList__cell BetaList__header'>Порт</td>
                <td className='BetaList__cell BetaList__header'>Владелец</td>
                <td className='BetaList__cell BetaList__header'>Создана</td>
                <td className='BetaList__cell BetaList__header'>Описание</td>
                {compact ? null : <td className='BetaList__cell BetaList__header'>Ветки</td>}
                {compact ? null : <td className='BetaList__cell BetaList__header'>БД</td>}
                {compact ? null : <td className='BetaList__cell BetaList__header'></td>}
            </tr>
        );
    }

    _renderBetas() {
        const {
            compact,
            betaList,
            listIsPending,
            dc,
            selectedBetaPort,
            pendingPort,
            onDeleteClick,
        } = this.props;

        const createdBetaCount = betaList.filter(beta => beta.status !== 'free').length;
        if (createdBetaCount === 0 && listIsPending === false) {
            return (
                <tr>
                    <td className='BetaList__cell BetaList__empty-list-label' colSpan={100}>Нет созданных бет</td>
                </tr>
            );
        } else if (listIsPending === true) {
            return (
                <tr>
                    <td className='BetaList__cell BetaList__spin-container' colSpan={100}>
                        <Spin size='xs'/>
                    </td>
                </tr>
            );
        }

        const username = cookie.parse(document.cookie).yandex_login;
        const {myBetas} = this.props;

        return betaList
            .filter(beta => {
                if (!myBetas) {
                    return true;
                }

                return beta.created_by === username;
            })
            // @ts-ignore
            .sort((a, b) => moment(b.created) - moment(a.created))
            .map((beta, index) => (
                <BetaListItem
                    selected={selectedBetaPort === beta.port}
                    compact={compact}
                    dc={dc}
                    canDelete={!pendingPort}
                    pending={Number(beta.port) === Number(pendingPort)}
                    key={beta.port}
                    onDeleteClick={() => onDeleteClick(beta.port)}
                    {...beta}
                />
            ));
    }
}

export default BetaList;
