import React from 'react';
import cn from 'classnames';
import {Button} from 'teatime-components';
import dcs from '../../dcs';

import './DcSelector.css';

export default function DcSelector(props) {
    const {current, onChange} = props;
    const availableDcList = dcs;

    return (
        <div className='DcSelector_root'>
            <span className={'DcSelector_caption'}>Выбранный хост:</span>
            {availableDcList.map((dc) => (
                <Button
                    key={dc}
                    className={cn('DcSelector_button', {
                        DcSelector_selected: current === dc,
                    })}
                    onClick={() => onChange(dc)}
                    theme='normal'
                >
                    {dc}
                </Button>
            ))}
        </div>
    );
}
