import React from 'react';
import moment from 'moment';

const HOURS_LABELS = [
    'час',
    'часа',
    'часов',
];

/*
 * @see https://github.com/sullenor/i18n-webpack-plugin/blob/dev/lib/plural/pluralForm07.js#L4
 */
function pluralForm07(value) {
  var quantity = parseInt(value, 10);

  if (isNaN(quantity)) return 0;

  var lastDigit = quantity % 10;

  if (
        lastDigit === 1 && quantity !== 11
    ) return 0;
  else if (
        lastDigit >= 2 && lastDigit <= 4 &&
        quantity !== 12 &&
        quantity !== 13 &&
        quantity !== 14
    ) return 1;

  return 2;
};

export default function TimeToLiveLabel(props) {
    const {created, ttl} = props;

    if (!ttl) {
        return null;
    }

    const endDate = moment(created).add(ttl, 'seconds');
    const hours = endDate.diff(moment(), 'hours');
    const hoursLabel = HOURS_LABELS[pluralForm07(hours)];

    return (
        <span>Будет удалена через&nbsp;{hours}&nbsp;{hoursLabel}</span>
    );
}
