import React from 'react';
import {connect} from 'react-redux';

import BetaDetails from '../../components/BetaDetails/BetaDetails';
import {
    deleteBeta,
    updateBeta,
    makeBetaAction,
    selectBeta,
    unselectBeta,
} from '../../actions/detailsActions';
import ErrorPopupContainer from '../ErrorPopupContainer/ErrorPopupContainer';
import Layout from '../../components/Layout/Layout';
import {getDcIndexListReducerName} from '../../utils/getDcIndexListReducerName';

const mapStateToProps = (state, ownProps) => {
    const {dc, port} = ownProps;
    const dcList = state[getDcIndexListReducerName(dc)];
    const beta = dcList
        ? dcList.betaList.filter(
            (beta) => Number(beta.port) === Number(port)
        )[0]
        : null;
    const {pendingPort, pendingDc, log} = state.details;
    const listIsPending = dcList && Boolean(dcList.listIsPending);
    const {productionBackendTag, productionFrontendTag} = state.createForm;

    return {
        dc,
        log,
        pendingPort,
        pendingDc,
        beta,
        listIsPending,
        productionBackendTag,
        productionFrontendTag,
    };
};

const mapDispatchToProps = (dispatch, {dc, port}) => ({
    onDeleteClick: () => dispatch(deleteBeta()),
    onStartClick: () => dispatch(makeBetaAction('start', dc, port)),
    onStopClick: () => dispatch(makeBetaAction('stop', dc, port)),
    onUpdateClick: (body) => dispatch(updateBeta(body)),
    onBetaSelect: (beta) => dispatch(selectBeta(dc, port)),
    onBetaUnselect: () => dispatch(unselectBeta()),
});

const BetaDetailsContainer = connect(
    mapStateToProps,
    mapDispatchToProps
)(BetaDetails);

export default function BetaDetailsPage({params: {dc, port}}) {
    return (
        <Layout Errors={ErrorPopupContainer}>
            <BetaDetailsContainer dc={dc} port={port} />
        </Layout>
    );
}
