import React from 'react';
import {connect} from 'react-redux';
import {createSelector} from 'reselect';

import AppFooter from '../../components/AppFooter/AppFooter';
import AppHeader from '../../components/AppHeader/AppHeader';
import CreateBetaForm from '../../components/CreateBetaForm/CreateBetaForm';
import ErrorPopupContainer from '../ErrorPopupContainer/ErrorPopupContainer';
import {getDcIndexListReducerName} from '../../utils/getDcIndexListReducerName';

import {
    createFormFieldChange,
    createBeta,
} from '../../actions/createBetaFormActions';

const freePortsSelector = createSelector(
    state => state[getDcIndexListReducerName(state.createForm.dc)].betaList,
    (betaList = []) => betaList.filter(beta => beta.status === 'free')
        .map(beta => {
            const port = String(beta.port);

            switch (port.substr(-2)) {
            case '97':
                return {label: 'Скриншутилка №1', value: port};
            case '98':
                return {label: 'Скриншутилка №2', value: port};
            case '99':
                return {label: 'Каноническая бета', value: port};
            default:
                return {label: port, value: port};
            }
        })
);

/**
 *
 * @param {string} value
 * @returns {string}
 */
const stripRegistryPrefix = (value) =>
    value.replace(/^registry(\.partner)?\.yandex(-team)?\.(ru|net|com)\//, '');

const selectUbuntuVersionsOpts = createSelector(
    (state) => state.createForm.ubuntuVersions,
    (rawVersions) => rawVersions.map((item) => ({ label: item, value: item }))
);

const selectDbImagesOpts = createSelector(
    (state) => state.createForm.dbImages[state.createForm.dc] || [],
    (rawImages) =>   rawImages.map(image => ({label: stripRegistryPrefix(image), value: image}))
)

const CreateBetaFormContainer = connect(
    state => ({
        dc: state.createForm.dc,
        dcs: state.createForm.dcs,

        ubuntuVersion: state.createForm.ubuntuVersion,
        ubuntuVersionsOpts: selectUbuntuVersionsOpts(state),

        freePortsOpts: freePortsSelector(state),

        dbs: state.createForm.dbs,
        migrationSqlFiles: state.createForm.migrationSqlFiles[state.createForm.dc],
        selectedMigrationSqlFiles: state.createForm.selectedMigrationSqlFiles,
        migrationScriptFiles: state.createForm.migrationScriptFiles[state.createForm.dc],
        selectedMigrationScriptFiles: state.createForm.selectedMigrationScriptFiles,
        withManual: state.createForm.withManual,

        dbImage: state.createForm.dbImage,
        dbImagesOpts: selectDbImagesOpts(state),

        port: state.createForm.port,
        backendBranch: state.createForm.backendBranch,
        frontendBranch: state.createForm.frontendBranch,
        javaBranch: state.createForm.javaBranch,

        db: state.createForm.db,
        blackbox: state.createForm.blackbox,
        yacotools: state.createForm.yacotools,
        bs: state.createForm.bs,
        adfox_host: state.createForm.adfox_host,
        comment: state.createForm.comment,
        ttl: state.createForm.ttl,

        productionBackendTag: state.createForm.productionBackendTag,
        productionFrontendTag: state.createForm.productionFrontendTag,

        pending: state.createForm.pending,
        errors: state.createForm.errors
    }),
    dispatch => ({
        onFieldChange: (fieldName, fieldValue) => dispatch(createFormFieldChange(fieldName, fieldValue)),
        onCreateClick: () => dispatch(createBeta())
    })
)(CreateBetaForm);

export default function CreateBetaPage() {
    return (
        <div className='App'>
            <ErrorPopupContainer/>
            <AppHeader />
                <CreateBetaFormContainer/>
            <AppFooter />
        </div>
    );
}
