import React from 'react';
import {connect} from 'react-redux';

import BetaList from '../../components/BetaList/BetaList';
import ErrorPopupContainer from '../ErrorPopupContainer/ErrorPopupContainer';
import Layout from '../../components/Layout/Layout';
import DcSelector from '../../components/DcSelector/DcSelector';
import {selectDc} from '../../actions/dcActions';
import {getDcIndexListReducerName} from '../../utils/getDcIndexListReducerName';

const ListContainer = connect(
    state => {
        const {dc: {dc}} = state;
        const dcList = state[getDcIndexListReducerName(dc)];

        return ({
            dc,
            header: `creator${dc}.partner.yandex.ru`,
            betaList: dcList.betaList,
            listIsPending: dcList.listIsPending,
        });
    }
)(BetaList);

function IndexPage(props) {
    const {dc, myBetas, selectedBeta, selectDc} = props;

    const content = (
        <div>
            <DcSelector current={dc} onChange={selectDc} />
            <table className='App__beta-list-table'>
                <ListContainer
                    compact={Boolean(selectedBeta)}
                    selectedBetaPort={selectedBeta && selectedBeta.dc === dc ? selectedBeta.port : null}
                    myBetas={myBetas}/>
            </table>
        </div>
    );

    return (
        <Layout Errors={ErrorPopupContainer}>
            {content}
        </Layout>
    );
}

function mapStateToProps(state) {
    const {
        dc: {
            dc,
        },
    } = state;
    return {
        dc,
    };
}

function mapDispatchToProps(dispatch) {
    return {
        selectDc: dc => dispatch(selectDc(dc)),
    };
}

const ConnectedIndexPage = connect(mapStateToProps, mapDispatchToProps)(IndexPage);

export default ConnectedIndexPage;
