import React from 'react';
import ReactDOM from 'react-dom';
import App from './components/App/App';
import './index.css';

import thunkMiddleware from 'redux-thunk';
import {compose, createStore, applyMiddleware, combineReducers} from 'redux';
import {Provider} from 'react-redux';

import {browserHistory} from 'react-router';
import {routerMiddleware} from 'react-router-redux';

import {initApp} from './actions/indexActions';
import dcs from './dcs';
import errorReducer from './reducers/errorReducer';
import indexReducer from './reducers/indexReducer';
import {createBetaFormReducer} from './reducers/createBetaFormReducer';
import detailsReducer from './reducers/detailsReducer';
import dcReducer from './reducers/dcReducer';
import {getDcIndexListReducerName} from './utils/getDcIndexListReducerName';

const reducers = {
  dc: dcReducer,
  error: errorReducer,
  createForm: createBetaFormReducer,
  details: detailsReducer
};

dcs.forEach(dc => {
  reducers[getDcIndexListReducerName(dc)] = indexReducer.bind(null, dc);
});

const composeEnhancers = typeof window === 'object' && window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__
    ? window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__
    : compose;

const store = createStore(
    combineReducers(reducers),
    composeEnhancers(applyMiddleware(thunkMiddleware, routerMiddleware(browserHistory)))
);

store.dispatch(initApp());

ReactDOM.render(
    (
        <Provider store={store}>
          <App />
        </Provider>
    ),
    document.getElementById('root')
);
