import {merge} from 'lodash';
import {sendLogs} from './sendLogs';
import {useStorageCache} from './storageCache';

export function simpleFetch(url, params = {}) {
    const body = JSON.parse((params && params.body) || '{}');
    const method = (params && params.method) || 'GET';

    return fetch(url, params)
        .then(response => {
            if (response.ok) {
                sendLogs(response.url, body, method);
            } else {
                return response.json().then(error => {
                    sendLogs(response.url, body, method, response.status, true, error);

                    return Promise.reject(error);
                })
            }

            return response;
        });
}

export function fetchJSON(url, opts) {
    const computedOpts = merge({
        credentials: 'same-origin',
        headers: {
            'Accept': 'application/json',
        },
    }, opts);
    return simpleFetch(url, computedOpts)
        .then(response => {
            const contentType = response.headers.get('content-type');

            if (contentType && contentType.includes('application/json')) {
                return response.json()
                    .catch(() => {
                        throw new Error('Invalid JSON in response for url ' + url);
                    });
            }

            throw new Error(`Bad response: ${response.status} ${response.statusText} for url ` + url);
        });
}

export const memoizedFetchJSON = useStorageCache(fetchJSON);
