export function sendLogs(url, reqBody, method, statusCode = 200, isError = false, response = {}) {
    const body = reqBody;

    body.method = method;
    body.statusCode = statusCode;
    body.status = isError ? 'fail' : 'success';
    body.url = url;

    if (isError) {
        body.response = response;
    }

    fetch('https://krush.partner.yandex-team.ru/v3/logger/creator-frontend', {
        body: JSON.stringify(body),
        headers: {
            'Content-Type': 'application/json',
        },
        method: 'POST',
    })
        .then(response => {
            if (!response.ok) {
                return Promise.reject(response);
            }
        })
        .catch(e => {
            throw new Error(`Can\'t send notification to krusher: ${e.message}`)
        })
}
