import hash from './hash';

const HOUR = 36e5;

export function useStorageCache(fn, duration = HOUR) {
    return cachedFetchFn;

    function cachedFetchFn(url, opts) {
        const method = typeof opts === 'object' && typeof opts.method === 'string'
            ? opts.method
            : 'get';

        if (method === 'get') {
            const cacheKey = hash(url);
            const cacheValue = localStorage.getItem(cacheKey);
            const parsedValue = cacheValue ? JSON.parse(cacheValue) : null;

            if (parsedValue) {
                if (Date.now() - parsedValue.time < duration) {
                    return Promise.resolve(parsedValue.response);
                } else {
                    localStorage.removeItem(cacheKey);
                }
            }

            return fn(url, opts)
                .then(json => {
                    const newCacheValue = JSON.stringify({response: json, time: Date.now()});
                    localStorage.setItem(cacheKey, newCacheValue);

                    return json;
                });
        }

        return fn(url, opts);
    }
}
