import {
    SELECT_BETA,
    RECEVE_LOG,
    UNSELECT_BETA,
    REQUEST_DELETE_BETA,
    BETA_DELETED,
    END_DELETE_BETA,
    REQUEST_BETA_ACTION,
    BETA_ACTION_MADE,
    END_MAKE_ACTION,
} from '../actions/detailsActions';

const INITIAL_STATE = {
    dc: null,
    port: null,
    log: null,
    pendingPort: null,
    pendingDc: null,
};

export default function detailsReducer(state = INITIAL_STATE, action) {
    const {type, dc, port, log} = action;

    switch (type) {
        case SELECT_BETA:
            return {dc, port, log: null};

        case RECEVE_LOG:
            return Object.assign({}, state, {log});

        case UNSELECT_BETA:
            return Object.assign({}, INITIAL_STATE);

        case REQUEST_DELETE_BETA:
        case REQUEST_BETA_ACTION:
            return Object.assign({}, state, {
                pendingPort: action.port,
                pendingDc: action.dc
            });

        case BETA_DELETED:
        case END_DELETE_BETA:
        case BETA_ACTION_MADE:
        case END_MAKE_ACTION:
            return Object.assign({}, state, {
                pendingPort: null,
                pendingDc: null
            });

        default:
            return state;
    }
}
