const INITIAL_STATE = {
    message: null
};

import {SET_ERROR, RESET_ERROR} from '../actions/errorActions';

export default function errorReducer(state = INITIAL_STATE, action) {
    const {type} = action;

    switch (type) {
        case SET_ERROR:
            const {message} = action;
            return Object.assign({}, state, {message});

        case RESET_ERROR:
            return Object.assign({}, state, {message: null});

        default:
            return state;
    }
}
