import {
    RECEIVE_BETA_LIST,
    RECEIVE_BETA_LIST_ERROR,
    REQUEST_BETA_LIST,
    UPDATE_BETA_IN_INDEX,
} from '../actions/indexActions';

const INITIAL_STATE = {
    betaList: [],
    listIsPending: false
};

export default function indexReducer(dc, state = INITIAL_STATE, action) {
    const {type, dc: actionDc} = action;

    if (!actionDc || dc !== actionDc) {
        return state;
    }

    switch (type) {
        case REQUEST_BETA_LIST:
            return Object.assign({}, state, {
                betaList: [],
                listIsPending: true
            });

        case RECEIVE_BETA_LIST:
            const {betaList} = action;
            return Object.assign({}, state, {
                betaList,
                listIsPending: false
            });

        case RECEIVE_BETA_LIST_ERROR:
            return Object.assign({}, state, {
                betaList: [],
                listIsPending: false
            });

        case UPDATE_BETA_IN_INDEX: {
            const {beta: newBetaData} = action;
            const betaList = state.betaList.map(beta => {
                if (beta.port === newBetaData.port) {
                    return newBetaData;
                }
                return beta;
            });

            return Object.assign({}, state, {betaList});
        }

        default:
            return state;
    }
}
