export type DBType = {
    type: 'preset' | 'docker';
    url: string;
    docker_image: string;
    migrationsql_files: string;
    migrationscript_files: string;
    preset_id: 'ts' | 'docker' | 'dev';
};

export type UbuntuVersions = 'bionic' | 'precise';
export type VersionStatuses = 'actual' | 'outdated';

export type BetaType = {
    comment: string;
    status: string;
    created: string;
    created_by: string;
    url: string;
    port: number;
    ttl: number;

    db: DBType;
    blackbox: {
        url: string;
        type: 'url';
    };
    bs: {url: string; type: 'url'};
    yacotools: {url: string};
    java: string | null;
    ubuntu_version: UbuntuVersions;

    frontend: string;
    frontend_status: VersionStatuses;
    frontend_sha1: string;

    backend: string;
    backend_status: VersionStatuses;
    backend_sha1: string;

    rosetta_debugger_url: string;
};
