'use strict';

const {resolve} = require('path');

module.exports = function tankerize(config) {
    config.tanker.project = 'pi-frontend';

    config.tanker.token = require('./tokenResolver');
    // config.tanker.branch = 'proto';

    config.tanker.original = 'ru';
    config.tanker.langs = ['ru', 'en'];

    // если этот параметр указан,
    // то вместо пустых переводов будут выгружены ключи на языке по умолчанию,
    // поэтому выключаем
    config.tanker.safe = false;
    config.tanker.status = 'unapproved';

    config.paths.tankerRsl = resolve(__dirname, './react/resolver.js');

    config.finders = [
        'grep -lr "__(" src | uniq',
    ];

    config.dispatchers.json = resolve(__dirname, './react/dispatcher.js');
    config.parsers.js = resolve(__dirname, './react/parser.js');
    config.parsers.ts = config.parsers.js;
    config.parsers.tsx = config.parsers.js;
    config.resolving.skip.push('keyset');
};
