'use strict';

const {assignWith} = require('lodash');

const getTicket = require('../ticketNameResolver');

/**
 * @param  {object} key
 * @return {object}
 */
module.exports = function resolve(key) {
    const ticket = getTicket();
    const defaults = {
        upload: true,
        plural: false,
        single: true,
        context: `https://st.yandex-team.ru/${ticket}`,
        comment: '',
        value: '',
    };
    const resolvedKey = assignWith(key, defaults, _customizer);

    if (key.plural) {
        resolvedKey.value = [
            '',
            '',
            '',
            '',
        ];
    }

    return resolvedKey;
};

/**
 * @private
 * @param  {*} value
 * @param  {*} other
 * @return {*}
 */
function _customizer(value, other) {
    return (value === null || value === undefined)
        ? other
        : value;
}
