'use strict';

const {execSync} = require('child_process');

const branchName = execSync('arc rev-parse HEAD', {encoding: 'utf-8'});
const groups = /^([A-Za-z]+-[0-9]+)_.*/.exec(branchName);

module.exports = function getTicket() {
    if (!groups || !groups[1]) {
        const branchNameOneLine = branchName.replace(/\n/, '');
        throw new Error(
            `Can't parse branch name. Check that your current branch "${branchNameOneLine}" contains correct ticket`
        );
    }

    return groups[1];
};
