'use strict';

const TOKEN_FILENAME = '.tanker-token';

const fs = require('fs');
const seekout = require('seekout');
const tankerTokenPath = seekout(TOKEN_FILENAME);
const {trim} = require('lodash');

/*
 * Для того, чтобы заработал танкер, нужно:
 *
 * 1. Получить OAuth-токен из-под своего логина по урлу https://nda.ya.ru/3SjQY7
 * 2. Положить его в ~/.tanker-token
 * 3. Сделать его доступным на чтение только для себя `chmod 400 ~/.tanker-token`
 */

if (tankerTokenPath === null) {
    throw new Error(`Can't find ${TOKEN_FILENAME} file with OAuth token`);
}

const tankerToken = fs.readFileSync(tankerTokenPath, {encoding: 'utf8'});

module.exports = trim(tankerToken);
