describe('ag_ph', () => {
    it('Открывает анкету', () => {
        cy.visit('/form');
        cy.wait(1000);

        // Анкета партнера
        cy.get('input[name=country] + span > input').type('США{enter}');
        cy.get('input[type=radio][name=branch][value=ag_ph] + label').click();

        // Контактная информация
        cy.get('input[type=text][name=field-latin_lastname]').type('Deckard');
        cy.get('input[type=text][name=field-latin_name]').type('Rick');
        cy.get('input[type=text][name=date-input]').type('28.09.1983');
        cy.get('body').click(100, 100);
        cy.get('input[type=text][name=field-email]').type('r.deckard@sanfranciscopolice.org');
        cy.get('input[type=text][name=field-phone]').type('+7 (999) 555 33 22');
        cy.upload_file('diner.jpg', 'image/jpeg', 'input[type=file][name=field-ag_ph_scan]');

        // Адрес
        cy.get('textarea[name=field-latin_freeform_address]').type('766 Vallejo Street, San Francisco, CA');
        cy.get('input[name=field-zip_code]').type('94133');

        // Платежная информация
        cy.get('input[name=field-account_owner]').type('Deckard, Rick');
        cy.get('input[name=field-currency] + span > button').click(5, 5);
        cy.get('input[name=field-currency] ~ span[role=listbox]').click(5, 5);
        cy.get('input[name=field-currency] + span > button').click(5, 5);
        cy.get('input[name=field-currency] ~ span[role=listbox]').click(5, 5);
        cy.get('input[name=field-swift]').type('INGBNL2A');
        cy.get('input[name=ibanOrAccountInput]').type('NL06INGB0020090358');
        cy.get('input[name=field-latin_bank_name]').type('Wells Fargo Bank');

        // Сайт или приложение
        cy.get('input[name=field-campaign_creation-domain-0]').focus().type('yandez.ru');
        cy.get('input[name=field-campaign_creation-link-0]').focus().type('https://metrika.yandex.ru/1234567');

        // Подтверждение
        cy.get('input[name=field-oferta_agreement] + label').click();

        // Отправить заявку на участие
        cy.get('button#submitFormButton').click();

        cy.url().should('include', '/v2/dashboard');
    });
});
