module.exports = {
    testRegex: '.*\\.test\\.(js|tsx?)$',
    moduleNameMapper: {
        '\\.p?css$': 'identity-obj-proxy',
    },
    moduleFileExtensions: [
        'ts',
        'tsx',
        'js',
        'json',
    ],
    setupFiles: [
        '<rootDir>/tests/setup.js',
    ],
    snapshotSerializers: [
        'enzyme-to-json/serializer',
    ],
    transform: {
        '^.+\\.js$': '<rootDir>/tests/js-transformer.js',
        '^.+\\.tsx?$': '<rootDir>/tests/typescript-transformer.js',
    },
    unmockedModulePathPatterns: [
        '<rootDir>/node_modules/react',
        '<rootDir>/node_modules/react-dom',
        '<rootDir>/node_modules/react-addons-test-utils',
        '<rootDir>/node_modules/fbjs',
    ],
    globals: {
        'ts-jest': {
            tsconfig: '<rootDir>/tsconfig.test.json',
            diagnostics: false,
        },
    },
    testURL: 'http://localhost',
};
