'use strict';

import PropTypes from 'prop-types';
import React from 'react';
import classNames from 'classnames';

import Img from '../Img/Img';

import {userPic} from './Avatar.css';

export default class Avatar extends React.Component {
    static defaultProps = {
        avatarId: '0/0-0',
        avatarUrl: '//avatars.yandex.net/get-yapic/${avatarId}/islands-retina-middle',
    };

    static propTypes = {
        avatarId: PropTypes.string,
        avatarUrl: PropTypes.string,
        className: PropTypes.string,
        onClick: PropTypes.func,
    };

    render() {
        const {avatarId, avatarUrl, className, onClick} = this.props;
        const avatarSrc = avatarUrl.replace('${avatarId}', avatarId);

        return (
            <Img
                className={classNames(userPic, className)}
                onClick={onClick}
                src={avatarSrc}/>
        );
    }
}
