'use strict';

import React from 'react';
import PropTypes from 'prop-types';

import {
    list,
    listItem,
    listDelimiter,
} from './List.css';

export default class List extends React.Component {
    static propTypes = {
        component: PropTypes.oneOfType([
            PropTypes.func,
            PropTypes.instanceOf(React.Component),
        ]),
        items: PropTypes.arrayOf(
            PropTypes.shape({
                children: PropTypes.string,
                key: PropTypes.string.isRequired,
                type: PropTypes.string,
            })
        ),
    }

    render() {
        const {component, items = []} = this.props;
        const renderedItems = items.map(item => renderListItem(component, item));

        return (
            <ul className={list}>
                {renderedItems}
            </ul>
        );
    }
}

function renderListItem(Component, item) {
    if (item.type === 'delimiter') {
        return (
            <li className={listDelimiter} key={item.key}/>
        );
    }

    return (
        <li
            className={listItem}
            key={item.key}>
            <Component {...item}/>
        </li>
    );
}
