'use strict';

import PropTypes from 'prop-types';
import React from 'react';
import classNames from 'classnames';

import {listLink} from './ListLink.css';

export default class ListLink extends React.Component {
    static propTypes = {
        children: PropTypes.string,
        className: PropTypes.string,
        href: PropTypes.string,
        target: PropTypes.string,
    }

    render() {
        const {
            children,
            className,
            href,
            target,
        } = this.props;

        return (
            <a
                className={classNames(listLink, className)}
                href={href}
                target={target}>
                {children}
            </a>
        );
    }
}
