'use strict';

import PropTypes from 'prop-types';
import React from 'react';
import classNames from 'classnames';

import Img from '../Img/Img';

import {
    container,
    link,
    yandex,
    advNetwork,
    en as enCls,
} from './Logo.css';

export default class Logo extends React.Component {
    static defaultProps = {
        locale: '',
        serviceUrl: '/',
        yandexUrl: 'https://yandex.ru',
    }

    static propTypes = {
        className: PropTypes.string,
        locale: PropTypes.string,
        serviceUrl: PropTypes.string,
        yandexUrl: PropTypes.string,
    }

    render() {
        const {className, locale, serviceUrl, yandexUrl} = this.props;
        const localeCls = locale === 'en' ? enCls : '';

        return (
            <span
                className={classNames(container, className)}>
                <a className={link} href={yandexUrl}>
                    <Img className={classNames(yandex, localeCls)}/>
                </a>
                <a className={link} href={serviceUrl}>
                    <Img className={classNames(advNetwork, localeCls)}/>
                </a>
            </span>
        );
    }
}
