'use strict';

import PropTypes from 'prop-types';
import React from 'react';
import classNames from 'classnames';

import {
    container,
    content,
    tail,
} from './Overlay.css';

export default class Overlay extends React.Component {
    static defaultProps = {
        shown: false,
        strategy: ['bottom', 'right', 'top', 'left'],
    }

    static propTypes = {
        children: PropTypes.any,
        shown: PropTypes.bool,
        strategy: PropTypes.array,
    }

    render() {
        const {children, shown, strategy} = this.props;

        if (!shown) {
            return null;
        }

        const direction = strategy[0];

        return (
            <div
                className={classNames(container, direction)}
                ref={r => this._overlay = r}>
                <div className={classNames(tail, direction)}/>
                <div className={content}>{children}</div>
            </div>
        );
    }
}
