'use strict';

import React from 'react';
import PropTypes from 'prop-types';
import ReactOutsideEvent from 'react-outside-event';

import Avatar from '../Avatar/Avatar';
import List from '../List/List';
import ListLink from '../ListLink/ListLink';
import Overlay from '../Overlay/Overlay';
import UserName from '../UserName/UserName';

import {
    container,
    avatarWrapper,
    avatar,
    login,
    mailIcon,
    diskIcon,
} from './User.css';

class User extends React.Component {
    // @todo menuItems
    static defaultProps = {
        avatarId: '0/0-0',
        avatarUrl: '//avatars.yandex.net/get-yapic/${avatarId}/islands-retina-middle',
        menuItems: [
            {children: 'Нет новых писем', className: mailIcon, key: 'noNewEmails', href: '#'},
            {children: 'Написать письмо', key: 'sendEmail', href: '#'},
            {children: 'Мой Диск', className: diskIcon, key: 'myDisk', href: '#'},
            {key: 'delimiter', type: 'delimiter'},
            {children: 'Настройка', key: 'settings', href: '#'},
            {children: 'Выйти', key: 'quit', href: '#'},
        ],
    }

    static propTypes = {
        avatarId: PropTypes.string,
        avatarUrl: PropTypes.string,
        children: PropTypes.string,
        menuItems: PropTypes.array,
    }

    constructor(props) {
        super(props);

        this.state = {
            opened: false,
        };

        this._onClick = this._onClick.bind(this);
    }

    onOutsideEvent() {
        if (this.state.opened) {
            this.setState({opened: false});
        }
    }

    _onClick() {
        this.setState({opened: !this.state.opened});
    }

    render() {
        const {avatarId, avatarUrl, children, menuItems} = this.props;
        const {opened} = this.state;

        const showMenu = menuItems && menuItems.length > 0;

        return (
            <span
                className={container}>
                <span className={avatarWrapper}>
                    <Avatar
                        avatarId={avatarId}
                        avatarUrl={avatarUrl}
                        className={avatar}
                        onClick={this._onClick}/>

                    <Overlay shown={showMenu && opened}>
                        <List component={ListLink} items={menuItems}/>
                    </Overlay>
                </span>
                <UserName
                    className={login}
                    onClick={this._onClick}>
                    {children}
                </UserName>
            </span>
        );
    }
}

export default ReactOutsideEvent(User);
