'use strict';

import PropTypes from 'prop-types';
import React from 'react';
import classNames from 'classnames';

import {name} from './UserName.css';

export default class UserName extends React.Component {
    static propTypes = {
        children: PropTypes.string,
        className: PropTypes.string,
        onClick: PropTypes.func,
    }

    render() {
        const {children, className, onClick} = this.props;

        if (!children) {
            return null;
        }

        return (
            <span
                className={classNames(name, className)}
                onClick={onClick}>
                {children}
            </span>
        );
    }
}
