'use strict';

const Bundler = require('parcel-bundler');
const {execSync} = require('child_process');
const {mkdirSync, readFileSync, writeFileSync} = require('fs');
const posthtml = require('posthtml');
const posthtmlExpressions = require('posthtml-expressions');
const crypto = require('crypto');

let result;

try {
    result = readFileSync('release_id');
} catch (e) {
    try {
        result = execSync('arc rev-parse HEAD');
    } catch (e) {
        console.log('Can\'t find release id');
        throw e;
    }
}
const release = result.toString('utf8').trim();

process.env.NODE_ENV = 'production';
process.env.LORDRAN_RELEASE = release.toString('utf8').trim();

const bundler = new Bundler('src/index.js', {
    outFile: 'dist/index.js',
    production: true,
    publicUrl: './',
    sourceMaps: false,
});

bundler.addAssetType('ts', require.resolve('../lib/TSasset'));
bundler.addAssetType('js', require.resolve('../lib/JSasset'));

console.log('👻  Cleaning up dist dir..');
execSync('rm -rf dist/');
mkdirSync('dist');

console.log('🏗  Building bundle..');
bundler.bundle().then(buildIndex);

// Building index.html
function buildIndex() {
    console.log('\n🏗  Building index.html..');

    const indexTemplate = readFileSync('src/index.prod.html').toString('utf8');
    const metrikaHtml = readFileSync('src/metrika.prod.html').toString('utf8');
    const indexJs = readFileSync('dist/index.js').toString('utf8');

    const hash = crypto.createHash('sha1');
    hash.update(indexJs, 'utf8');

    const hashHex = hash.digest('hex');

    // console.log(indexTemplate, metrikaHtml, hash);

    const renderedIndex = posthtml()
        .use(posthtmlExpressions({
            locals: {
                hash: hashHex,
                metrika: metrikaHtml,
            },
        }))
        .process(indexTemplate, {sync: true})
        .html;

    writeFileSync('dist/index.html', renderedIndex, 'utf8');
}
