'use strict';

const {execSync} = require('child_process');

const sentryUrl = 'https://sentry.t.yandex-team.ru';
const sentryOrg = 'partnerinterface';
const sentryProject = 'form-lordran';

let result;

try {
    result = execSync('arc rev-parse HEAD');
} catch (e) {
    throw new Error('Can\'t get commit id');
}

const release = result.toString('utf8').trim();

if (!release) {
    throw new Error('Can\'t get commit id');
}

console.log('Creating new release in Sentry');
execSync(`sentry-cli --url ${sentryUrl} releases -o ${sentryOrg} new -p ${sentryProject} ${release}`);

console.log('Uploading source maps');
execSync(`sentry-cli --url ${sentryUrl} releases -o ${sentryOrg} -p ${sentryProject} files \
  ${release} upload-sourcemaps --url-prefix '/dist' dist/`);
