'use strict';

const express = require('express');
const proxy = require('http-proxy-middleware');
const Bundler = require('parcel-bundler');
const https = require('https');
const fs = require('fs');

// eslint-disable-next-line no-sync
const certAndKey = fs.readFileSync('../nginx/localhost.yandex.ru.pem');

const app = express();

app.use('/form/api', proxy({target: 'https://localhost.yandex.ru', changeOrigin: true, secure: false}));
app.use('/restapi', proxy({target: 'https://localhost.yandex.ru', changeOrigin: true, secure: false}));

const useCache = !process.argv.includes('--no-cache');

const bundler = new Bundler('src/index.dev.html', {
    cache: useCache,
    hmr: false,
    sourceMaps: false,
});
bundler.addAssetType('ts', require.resolve('../lib/TSasset'));
bundler.addAssetType('js', require.resolve('../lib/JSasset'));

app.use('/', bundler.middleware());

https.createServer({cert: certAndKey, key: certAndKey}, app).listen(3000);
