// @flow
'use strict';

import * as React from 'react';
import classnames from 'classnames';

import css from './ColumnLayout.css';

type PropsT = {
    className?: string,
    leftChild?: React.Element<*>,
    rightChild?: React.Element<*>,
};

export class ColumnLayout extends React.Component<PropsT> {
    render(): React.Element<*> {
        const {className, leftChild, rightChild} = this.props;

        return (
            <div className={classnames(css.content, className)}>
                <div className={css.leftColumn}>
                    {leftChild}
                </div>
                <div className={css.rightColumn}>
                    <div className={css.rightColumnContent}>
                        {rightChild}
                    </div>
                </div>
            </div>
        );
    }
}
