// @flow
'use strict';

import * as React from 'react';
import cn from 'classnames';
import Markdown from 'markdown-to-jsx';

import css from './GfmText.css';

type PropsT = {
    text: string,
    style: 'default' | 'gdpr';
};

export class GfmText extends React.Component<PropsT> {
    render(): React.Element<*> | null {
        const {text, style} = this.props;

        return (
            <Markdown className={cn(
                css.text,
                {[css.gdpr]: style === 'gdpr'}
            )}>
                {text}
            </Markdown>
        );
    }
}
