// @flow
'use strict';

import * as React from 'react';

import css from './HintBox.css';

type PropsT = {
    children?: React.Node,
    title?: string,
};

export class HintBox extends React.Component<PropsT> {
    render(): React.Element<*> | null {
        const {children} = this.props;

        if (!children) {
            return null;
        }

        return (
            <div className={css.hintBox}>
                {this._renderTitle()}
                <span className={css.hintBody}>
                    {children}
                </span>
            </div>
        );
    }

    _renderTitle(): React.Element<*> | null {
        const {title} = this.props;

        if (!title) {
            return null;
        }

        return (
            <div className={css.hintTitle}>
                {title}
            </div>
        );
    }
}
