// @flow
'use strict';

import * as React from 'react';

import css from './Offer.css';

export type PropsT = {
    html: string,
};

export class Offer extends React.Component<PropsT> {
    render(): React.Element<*> {
        const {html} = this.props;

        const opts = {__html: html};

        return (
            <div className={css.offer} dangerouslySetInnerHTML={opts} />
        );
    }
}
