// @flow
'use strict';

import * as React from 'react';
import {Link, Check} from 'teatime-components';

type PropsT = {
    linkSize: string,
    message: string,
    offerUrl: string,
};

export class OfferCheck extends React.Component<PropsT> {
    render(): React.Element<*> | null {
        return (
            <Check
                {...this.props}
                label={this._getLabel()}
            />
        );
    }

    _getLabel(): React.Element<*> {
        const {offerUrl, message, linkSize} = this.props;

        const messageRegExp = /(.*)\[linkStart\](.*)\[linkEnd\](.*)/;

        const results = messageRegExp.exec(message);

        if (results.length !== 4) {
            return (
                <span>
                    {message}
                </span>
            );
        }

        // eslint-disable-next-line no-unused-vars
        const [msg, before, link, after] = results;

        return (
            <span>
                {before}
                <Link size={linkSize} href={offerUrl} target='_blank'>
                    {link}
                </Link>
                {after}
            </span>
        );
    }
}
