// @flow
'use strict';

const {Component} = require('react');
const React = require('react');
const classNames = require('classnames');

const css = require('./Overlay.css');

type StrategyT = 'bottom' | 'right' | 'top' | 'left';
type Props = {
    children?: React.Node,
    shown: boolean,
    strategy: Array<StrategyT>,
};

class Overlay extends Component<Props> {
    static defaultProps = {
        shown: false,
        strategy: ['bottom', 'right', 'top', 'left'],
    }

    render() {
        if (!this.props.shown) {
            return null;
        }

        const {children, strategy} = this.props;
        const direction = strategy[0];

        return (
            <div
                className={classNames(css.container, css[direction])}>
                <div className={classNames(css.tail, css[direction])}/>
                <div className={css.content}>{children}</div>
            </div>
        );
    }
}

module.exports = Overlay;
