// @flow
'use strict';

import * as React from 'react';
import {Link} from 'teatime-components';

import css from './Stages.css';

type StageT = {
    name: string,
    checked: boolean,
}

export type PropsT = {
    stages: Array<StageT>,
    supportUrl: string,
};

export class Stages extends React.Component<PropsT> {
    render(): React.Element<*> {
        const {supportUrl} = this.props;

        return (
            <div className={css.body}>
                {this._renderStages()}
                <div className={css.hr}></div>
                <Link
                    className={css.supportLink}
                    href={supportUrl}
                    target='_blank'
                >
                    {__('Contact support')}
                </Link>
            </div>
        );
    }

    _renderStages(): Array<React.Element<*>> {
        const {stages} = this.props;

        return stages.map(this._renderStage);
    }

    _renderStage(stage: StageT): React.Element<*> {
        const {checked, name} = stage;

        return (
            <div className={css.stage} key={`stage-${name}`}>
                <div className={checked ? css.checked : css.unchecked}></div>
                <div className={css.stageLabel}>{name}</div>
            </div>
        );
    }
}
