// @flow
'use strict';

import classnames from 'classnames';
import React from 'react';
import css from './UserSettingsButton.css';

type PropsT = {
    className?: string,
    onClick: (id: string) => void,
    id: string,
    label?: string
}

export class UserSettingsButton extends React.Component<PropsT> {
    static defaultProps = {
        onClick: () => {},
    }

    constructor(props: PropsT) {
        super(props);

        this._onClick = this._onClick.bind(this);
    }

    _onClick: () => void

    /* eslint-disable indent */
    render() {
        const {className, label} = this.props;

        return (
            <div className={classnames(css.root, className)}>
                <span className={css.icon} onClick={this._onClick}></span>
                {
                    label
                        ? <span className={css.label} onClick={this._onClick}>{label}</span>
                        : null
                }
            </div>
        );
    }
    /* eslint-enable indent */

    _onClick(): void {
        const {id, onClick} = this.props;
        onClick(id);
    }
}
