// @flow
'use strict';

import {connect} from 'react-redux';

import {ErrorStack} from '../../components/ErrorStack/ErrorStack';
import {removeError} from '../../actions';

import type {ApplicationStateT} from '../../types/state';

function _mapStateToProps(state: ApplicationStateT) {
    const {local: {errorStack = []}} = state;

    return {
        errors: errorStack,
    };
}

function _mapDispatchToProps(dispatch: Function) {
    return {
        onDeleteClick: (id: string) => dispatch(removeError(id)),
    };
}

const Container = connect(_mapStateToProps, _mapDispatchToProps)(ErrorStack);

export {
    Container as ErrorStack,
};
