// @flow
'use strict';

import * as React from 'react';

import {Fields} from '../Fields/Fields';
import {FormStages} from '../FormStages/FormStages';

import {ColumnLayout} from '../../components/ColumnLayout/ColumnLayout';

type PropsT = {
    className?: string,
};

export class FormContent extends React.Component<PropsT> {
    render(): React.Element<*> {
        const {className} = this.props;

        return (
            <ColumnLayout
                className={className}
                leftChild={(<Fields />)}
                rightChild={(<FormStages />)}
            />
        );
    }
}
