// @flow
'use strict';

import {connect} from 'react-redux';
import {withRouter} from 'react-router';

import {submit, changeLocale} from '../../actions';

import {Page} from '../../components/Page/Page';
import {ErrorStack} from '../ErrorStack/ErrorStack';

import {areFieldsReady, haveUnskippableFields} from '../../lib/fields';
import {isSimpleFormSelector} from '../../selectors/remote.ts';

import type {Dispatch} from 'redux';
import type {ApplicationStateT} from '../../types/state';

import type {UserDataT} from '../../types/state';

type ComponentT = Class<React$Component<*, *>>;

type PropsT = {
    user?: UserDataT,
    ErrorStackContainer: ComponentT,
}

const FormPage = withRouter(connect(
    function mapStateToProps(state: ApplicationStateT): PropsT {
        const {remote: {user, branch}, store} = state;
        const {local: {pending = 0}} = state;

        const submitReadiness = branch && haveUnskippableFields(branch.fields)
            ? areFieldsReady(store, branch.fields)
            : null;

        return {
            submitDisabled: pending > 0 || !submitReadiness,
            pending: pending > 0,
            user,
            ErrorStackContainer: ErrorStack,
            isSimpleForm: isSimpleFormSelector(state),
        };
    },
    function mapDispatchToProps(dispatch: Dispatch<*>): * {
        return {
            onSubmit: () => {
                dispatch(submit());
            },
            onChangeLang: (event, lang) => {
                dispatch(changeLocale(lang));
            },
        };
    },
)(Page));

export {
    FormPage,
};
