// @flow
'use strict';

import {connect} from 'react-redux';

import {Stages} from '../../components/Stages/Stages';

import {getFilledGroups} from '../../lib/fields';
import {getSupportUrl} from '../../lib/utils';

import type {ApplicationStateT} from '../../types/state';
import type {PropsT as StagesPropsT} from '../../components/Stages/Stages';

export const FormStages = connect(
    function mapStateToProps(state: ApplicationStateT): StagesPropsT {
        const {
            local: {branchId, countryId, fieldGroups},
            remote: {branch, user = {}},
            store,
        } = state;

        const {force} = user;

        const filledGroups = fieldGroups && branch && Object.keys(store).length > 0
            ? getFilledGroups(fieldGroups, store, branch.fields)
            : [];

        const defaultGroups = [
            {
                checked: Boolean(countryId),
                name: __('Country'),
            },
            {
                checked: Boolean(branchId),
                name: __('Partnership form'),
            },
        ];

        return {
            stages: force ? filledGroups : defaultGroups.concat(filledGroups),
            supportUrl: getSupportUrl(),
        };
    },
)(Stages);
