// @flow
'use strict';

import {connect} from 'react-redux';

import {Offer} from '../../components/Offer/Offer';

import type {ApplicationStateT} from '../../types/state';
import type {PropsT as OfferPropsT} from '../../components/Offer/Offer';

const Component = connect(
    function mapStateToProps(state: ApplicationStateT): OfferPropsT {
        const {remote: {offer}} = state;

        if (!offer) {
            return {html: ''};
        }

        const {html} = offer;

        return {
            html,
        };
    },
)(Offer);

export {
    Component as Offer,
};
